<?php include_once('header.php'); ?>

<div class="container">
  <div class="card-deck mb-3 text-center">
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap mt-3 align-items-center pb-2 mb-3 border-bottom" style="width: 100%;">
      <h1 class="h2">Add New Sacco</h1>

      <div class="btn-toolbar mb-2 mb-md-0">
        <div class="btn-group mr-2">
          <a class="btn btn-sm btn-outline-secondary" href="sacco_list.php">Sacco List</a>
          <a class="btn btn-sm btn-outline-secondary" href="sacco_stats.php">Sacco Statistics</a>
        </div>
      </div>
    </div>


    <!-- new vacancy section -->
    <div id="new-vacancy" style="width: 100%">

      <div class="d-flex justify-content-between flex-wrap flex-md-nowrap mt-3 pb-2 mb-3 border-bottom" style="width: 100%; text-align: left;">
        <div class="col-md-12 order-md-1">
          <div id="error"></div>
          <form id="add-sacco" method="post" action="">
            <div class="row mb-4">
              <div class="col-md-4 mb-3">
                <label for="Password">Sacco Name</label>
                <input type="text" class="form-control" name="sacco">

              </div>
              <div class="col-md-4 mb-3">
                <label for="firstName">Region</label>
                <select class="form-control" name="region">
                  <option value="">Choose Region</option>
                  <?php
                  $regions = $con->getRows('regions', array('order_by' => 'region_id'));
                  if (!empty($regions)) {
                    foreach ($regions as $region) {
                      echo '<option value="' . $region['region_id'] . '">' . $region['region_name'] . '</option>';
                    }
                  }
                  ?>
                </select>
              </div>
              <div class="col-md-4 mb-3">
                <label for="Password">Location</label>
                <input type="text" class="form-control" name="location">

              </div>

            </div>
            <div class="row">
              <div class="col-md-4 mb-3">
                <label for="Password">Contact Person</label>
                <input type="text" class="form-control" name="contact">
              </div>
              <div class="col-md-4 mb-3">
                <label for="Password">Email Address</label>
                <input type="email" class="form-control" name="email">
              </div>
              <div class="col-md-4 mb-3">
                <label for="Password">Phone Number</label>
                <input type="text" class="form-control" name="phone">
              </div>
            </div>

            <div class="row">
              <div class="col-md-6 mb-3">
                <label for="Password">Postal Address</label><br>
                <input type="text" class="form-control" name="address">
              </div>
              <div class="col-md-6 mb-3">
                <label for="Password">Website URL</label><br>
                <input type="url" class="form-control" name="url" placeholder="Start with https:// or http://">
              </div>
            </div>
            <button class="btn btn-primary btn-md" type="submit" name="save_sacco" id="save_sacco" style="float: right; margin-right: 5px;">
              Save Sacco
            </button>
          </form>
        </div>
      </div>

    </div>
    <!-- end new user form -->
  </div>

</div>


<!-- Bootstrap core JavaScript
    ================================================== -->
<!-- Placed at the end of the document so the pages load faster -->
<script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
<script src="../../js/vendor/popper.min.js"></script>
<script src="../../js/bootstrap.min.js"></script>
<script src="../../js/vendor/holder.min.js"></script>
<script type="text/javascript" src="../../js/jquery-3.2.1.min.js"></script>
<script type="text/javascript" src="../../js/validation.min.js"></script>
<script src="../../js/tables/jquery.dataTables.js"></script>
<script src="../../js/tables/dataTables.bootstrap4.js"></script>

<!--  summernote JS
        ============================================ -->
<script src="../../js/summernote/summernote-updated.min.js"></script>
<script src="../../js/summernote/summernote-active.js"></script>

<script>
  $(document).ready(function() {

    //adds a new vacancy
    /* validation */
    $("#add-sacco").validate({
      rules: {
        sacco: {
          required: true
        },
        location: {
          required: true
        },
        region: {
          required: true
        },
        contact: {
          required: true
        },
      },
      messages: {
        sacco: {
          required: "Please enter sacco name"
        },
        location: "Please enter sacco location",
        region: "Please enter sacco region",
        contact: "Please enter sacco's contact person",
      },
      submitHandler: submitForm
    });
    /* validation */

    /* login submit */
    function submitForm() {
      var data = $("#add-sacco").serialize();

      $.ajax({

        type: 'POST',
        url: 'sql_statements.php',
        data: data,
        beforeSend: function() {
          $("#error").fadeOut();
          $("#save_sacco").html('<i class="fa fa-spin fa-spinner"></i> Saving Sacco...');
        },
        success: function(response) { //alert(response);
          if (response == 1) {
            $("#error").fadeIn(1000, function() {
              $("#error").html('<div class="alert alert-success alert-dismissible" role="alert"> <button type="button" class="close" data-dismiss="alert">×</button><i class="icon wb-check" aria-hidden="true"></i> A new sacco has been saved successfuly.</div>');
              $("#save_sacco").html('Save Sacco');
              $("#add-sacco")[0].reset();
            });
            $("#error").delay(6000).fadeOut(function() {});
            //setTimeout('window.location.href = "admin/dashboard.php"; ', 1000);
          }
          //login error
          else if (response == 2) {
            $("#error").fadeIn(1000, function() {
              $("#error").html('<div class="alert alert-danger alert-dismissible" role="alert"> <button type="button" class="close" data-dismiss="alert">×</button><i class="icon wb-warning" aria-hidden="true"></i> There is an error saving the new sacco, please try again.</div>');
              $("#save_sacco").html('Save Sacco');
            });
            $("#error").delay(6000).fadeOut(function() {});
          }

        }
      });
      return false;
    }
    /*end add vacancy script */


  });

  //delete vacancy details details
  $(document).on('click', '.btn_delete', function() {
    var id = $(this).data("id3");
    var delete_vacancy = "delete_vacancy";
    //alert(user+" "+id);
    if (confirm("Are you sure you want to remove this Vacancy?" + id)) {
      $.ajax({
        url: "sql_statements.php",
        method: "POST",
        data: {
          vacancy_id: id,
          delete_vacancy: delete_vacancy
        },
        dataType: "text",
        success: function(data) {
          //alert(data);
          if (data == 1) {
            $("#error").fadeIn(2000, function() {
              $("#error").html('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-ok-circle"></span>&nbsp; A vacancy has been removed!</div>');
            }); //Your username/password entered doesn't match
            $("#error").fadeOut(5000, function() {});
          }
          fetchData();
        }
      });
    }
  });

  //show vacancy details
  $(document).on('click', '.show_btn', function() {
    var id = $(this).data("id3");
    var show_vacancy = "show_vacancy";

    //alert(id);

    $.ajax({
      url: "sql_statements.php",
      method: "POST",
      data: {
        vacancy_id: id,
        show_vacancy: show_vacancy
      },
      dataType: "text",
      success: function(data) {
        //alert(data);
        if (data == 1) {
          $("#error").fadeIn(2000, function() {
            $("#error").html('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-ok-circle"></span>&nbsp; A vacancy can now be accessed by the public!</div>');
          }); //Your username/password entered doesn't match
          $("#error").fadeOut(5000, function() {});
        }
        fetchData();
      }
    });

  });

  //show vacancy details
  $(document).on('click', '.hide_btn', function() {
    var id = $(this).data("id3");
    var hide_vacancy = "hide_vacancy";

    //alert(id);

    $.ajax({
      url: "sql_statements.php",
      method: "POST",
      data: {
        vacancy_id: id,
        hide_vacancy: hide_vacancy
      },
      dataType: "text",
      success: function(data) {
        alert(data);
        if (data == 1) {
          $("#error").fadeIn(2000, function() {
            $("#error").html('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-ok-circle"></span>&nbsp; A vacancy has been hidden from the public/expired!</div>');
          }); //Your username/password entered doesn't match
          $("#error").fadeOut(5000, function() {});
        }
        fetchData();
      }
    });

  });

  Holder.addTheme('thumb', {
    bg: '#55595c',
    fg: '#eceeef',
    text: 'Thumbnail'
  });
</script>
</body>

</html>