<?php session_start(); ?>
<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="icon" href="../../images/icon.png">

    <title>Admin Dashboard</title>

    <!-- Bootstrap core CSS -->
    <link href="../../css/bootstrap.min.css" rel="stylesheet">

    <!-- Custom styles for this template -->
    <link href="../../css/pricing.css" rel="stylesheet">

    <!-- icons -->
    <link type="text/css" href="../../css/font-awesome.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="../../css/font-awesome.min.css">

    <link rel="stylesheet" href="../../css/tables/dataTables.bootstrap4.css" />
    <style type="text/css">
      #create-user .error{
        border-color: #ecbeb6;
        color: #b55351;
        text-transform: capitalize;
        text-align: left !important;
       }
       #error{
        width: 100%;
       }
       .alert{
            width: 100%;
            text-align: left;
        }
       }
    </style>
  </head>

  <body>

    <div class="d-flex flex-column flex-md-row align-items-center p-3 px-md-4 mb-3 bg-white border-bottom box-shadow">
      <h5 class="my-0 mr-md-auto font-weight-normal"> <img class="mb-2" src="../../images/clickit_logo.png" alt="" width="35%"> | Online Portal</h5>
      <nav class="my-2 my-md-0 mr-md-3">
        <a class="p-2 text-dark" href="system_users.php"><i class="fa fa-users"></i> System Users</a>
        <a class="p-2 text-dark" href="suppliers.php"><i class="fa fa-truck"></i> Suppliers</a>
        <a class="p-2 text-dark" href="account_settings.php"><i class="fa fa-cogs"></i> Account Settings</a>
      </nav>
      <a class="btn btn-outline-primary" href="../../logout.php">
        <i class="fa fa-sign-out"></i> Sign Out
      </a>
    </div>




    <div class="container">
      <div class="card-deck mb-3 text-center">
        <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom" style="width: 100%;">
            <h1 class="h2">System Users</h1>
            <div class="btn-toolbar mb-2 mb-md-0">
              <div class="btn-group mr-2">
                <button class="btn btn-sm btn-outline-secondary" id="new_user">New User</button>
                <button class="btn btn-sm btn-outline-secondary" id="user_logs">User Logs</button>
              </div>
            </div>
          </div>

          <div id="error"></div>
          <!-- new user section -->
          <div id="new-user" style="width: 100%">
          <div class="d-flex justify-content-between flex-wrap flex-md-nowrap  pb-2 mb-3 border-bottom" style="width: 100%; text-align: left;">
            <div class="col-md-12 order-md-1">
          <h4 class="mb-3">Create New User
            <button style="float: right;" id="hide" class="btn btn-md btn-primary">Close</button>
          </h4>
          
          <form class="needs-validation" id="create-user" method="post">
            <div class="row">
              <div class="col-md-4 mb-3">
                <label for="firstName">First name</label>
                <input type="text" class="form-control" id="firstName" name="firstName" required>
              </div>
              <div class="col-md-4 mb-3">
                <label for="firstName">First name</label>
                <input type="text" class="form-control" id="lastName" name="lastName" required>
              </div>
              <div class="col-md-4 mb-3">
                <label for="lastName">Email Address</label>
                <input type="email" class="form-control" id="email" name="email" required>
                
              </div>
            </div>
            <div class="row">
              <div class="col-md-4 mb-3">
                <label for="country">Account Type</label>
                <select class="custom-select d-block w-100" id="country" name="type" required>
                  <option value="">Choose...</option>
                  <option value="procurement">Procurement Staff</option>
                  <option value="manager">Managers/CD</option>
                </select>
              </div>
              <div class="col-md-4 mb-3">
                <label for="Username">Username</label>
                <input type="text" class="form-control" id="username" name="username" required>
              </div>
              <div class="col-md-4 mb-3">
                <label for="Password">Password</label>
                <input type="password" class="form-control" id="password" name="password" required>
                
              </div>
            </div>
            <button class="btn btn-primary btn-md" type="reset" name="reset" id="reset" style="float: right;">
               Clear Form   
            </button>
            <button class="btn btn-primary btn-md" type="submit" name="create_account" id="create_account" style="float: right; margin-right: 5px;">
               Create User
            </button>
          </form>
        </div>
      </div>
          </div>
          <!-- end new user form -->
          
          <div class="table-responsive">
            <div id="live_data" style="width: 100%; text-align: left;"></div>
          </div>
      </div>

      <footer class="pt-4 my-md-5 pt-md-5 border-top">
        <div class="row">
          <div class="col-12 col-lg">
            <img class="span6" src="../../images/clickit_logo.png" alt="" width="50%">
            <img class="mb-2" src="../../images/clickit_logo.png" alt="" width="50%">
            <img class="mb-2" src="../../images/clickit_logo.png" alt="" width="50%">
            <small class="d-block mb-3 text-muted">&copy; 2017-2018</small>
          </div>
          <div class="col-6 col-md">
            <h5>Features</h5>
            <ul class="list-unstyled text-small">
              <li><a class="text-muted" href="#">Cool stuff</a></li>
              <li><a class="text-muted" href="#">Random feature</a></li>
              <li><a class="text-muted" href="#">Team feature</a></li>
              <li><a class="text-muted" href="#">Stuff for developers</a></li>
              <li><a class="text-muted" href="#">Another one</a></li>
              <li><a class="text-muted" href="#">Last time</a></li>
            </ul>
          </div>
          <div class="col-6 col-md">
            <h5>Resources</h5>
            <ul class="list-unstyled text-small">
              <li><a class="text-muted" href="#">Resource</a></li>
              <li><a class="text-muted" href="#">Resource name</a></li>
              <li><a class="text-muted" href="#">Another resource</a></li>
              <li><a class="text-muted" href="#">Final resource</a></li>
            </ul>
          </div>
          <div class="col-6 col-md">
            <h5>About</h5>
            <ul class="list-unstyled text-small">
              <li><a class="text-muted" href="#">Team</a></li>
              <li><a class="text-muted" href="#">Locations</a></li>
              <li><a class="text-muted" href="#">Privacy</a></li>
              <li><a class="text-muted" href="#">Terms</a></li>
            </ul>
          </div>
        </div>
      </footer>
    </div>


    <!-- Bootstrap core JavaScript
    ================================================== -->
    <!-- Placed at the end of the document so the pages load faster -->
    <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
    <script>window.jQuery || document.write('<script src="../../js/vendor/jquery-slim.min.js"><\/script>')</script>
    <script src="../../js/vendor/popper.min.js"></script>
    <script src="../../js/bootstrap.min.js"></script>
    <script src="../../js/vendor/holder.min.js"></script>
    <script type="text/javascript" src="../../js/jquery-3.2.1.min.js"></script>
    <script type="text/javascript" src="../../js/validation.min.js"></script>
    <script src="../../js/tables/jquery.dataTables.js"></script>
    <script src="../../js/tables/dataTables.bootstrap4.js"></script>

    <script>
      (function($) {
      'use strict';
      $(function() {
        $('#order-listing').DataTable({
          "aLengthMenu": [
          [10, 20, 35, -1],
          [10, 20, 35, "All"]
          ],
          "iDisplayLength": 10
        });
      });
    })(jQuery);


    function fetchData(){
      $.ajax({  
          url:"select-users.php",  
          method:"POST",  
          success:function(data){  
               $('#live_data').html(data);  
          }  
         });
    }
      $(document).ready(function(){

        //loads system users 
        $.ajax({  
          url:"select-users.php",  
          method:"POST",  
          success:function(data){  
               $('#live_data').html(data);  
          }  
         }); 

        $('#new-user').hide();//hide new user form on page load
        //when a new user button has been clicked
        $('#new_user').click(function(){
          $("#new-user").show();
          $("#hide").click(function(){$("#new-user").hide();})
        });


        //user login script
       /* validation */
       $("#create-user").validate({
          rules:
        {
          password: {
          required: true
          },
          username: {
                required: true
                },
         },
           messages:
         {
                password:{
                          required: "Please enter password"
                         },
                username: "Please enter your username",
           },
         submitHandler: submitForm  
           });  
         /* validation */
         
         /* login submit */
         function submitForm()
         {    
          var data = $("#create-user").serialize();    
           
          $.ajax({
            
          type : 'POST',
          url  : 'sql_statements.php',
          data : data,
          beforeSend: function()
          { 
            $("#error").fadeOut();
            $("#create_account").html('<i class="fa fa-spin fa-spinner"></i> Creating Account ...');
          },
          success :  function(response)
             {  //alert(response);

              //if the response returns true
              if(response == 1){                 
                $("#error").fadeIn(2000, function(){            
                  $("#error").html('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-ok-circle"></span> User account has been created! Clear the form to add a new user.</div>');
                  });
                $("#error").fadeOut(5000,function(){$("#new-user").hide();});
                //$("#new-user").fadeOut(9000,function(){});
                $("#create_account").html('Create New User ...');
                fetchData(); 

              }
              else if(response == 2){                 
                $("#error").fadeIn(2000, function(){            
                  $("#error").html('<div class="alert alert-error"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-lock"></span> There was an error creating a user account, Please try again!</div>');
                $("#login").html('<span class="fa fa-lock"></span> &nbsp; Account Locked');
                      });//Your username/password entered doesn't match
                $("#error").fadeOut(180000,function(){});
              }

            }
          });
            return false;
        }
         /* login submit */
      });

      //delete user details
      $(document).on('click', '.btn_delete', function(){  
             var id=$(this).data("id3");
             var delete_user="delete_user";
             //alert(user+" "+id); 
             if(confirm("Are you sure you want to remove this user?"))  
             {  
                  $.ajax({  
                       url:"sql_statements.php",  
                       method:"POST",  
                       data:{userid:id, delete_user:delete_user},  
                       dataType:"text",  
                       success:function(data){  
                            //alert(data); 
                          if(data == 1){
                              $("#error").fadeIn(2000, function(){            
                  $("#error").html('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-ok-circle"></span>&nbsp; User account has been removed!</div>');
                      });//Your username/password entered doesn't match
                $("#error").fadeOut(5000,function(){});
                            } 
                            fetchData();  
                       }  
                  });  
             }  
        });  
      Holder.addTheme('thumb', {
        bg: '#55595c',
        fg: '#eceeef',
        text: 'Thumbnail'
      });

    </script>
  </body>
</html>
